%% Displacement vs Knee Angle
% Calf
figure(1)
load('Pinjointshank.mat');
plot(Shank50_Deformation(:,1), 1000*Shank50_Deformation(:,2),'LineWidth',3,'color',[.5 .5 .5]);
hold on
load('Pinjointthigh.mat');
plot(Thigh50_Deformation(:,1), 1000*Thigh50_Deformation(:,2),'LineWidth',3,'color',[.753 .0 .0]);
hold on
load('Shank45_Deformation.mat');
plot(Shank50_Deformation(:,1), 1000*Shank50_Deformation(:,2),'LineWidth',3,'color',[.5 .5 .5]);
hold on
load('Shank60_Deformation.mat');
plot(Shank50_Deformation(:,1), 1000*Shank50_Deformation(:,2),'LineWidth',3,'color',[.5 .5 .5]);
hold on
load('Shank75_Deformation.mat');
plot(Shank50_Deformation(:,1), 1000*Shank50_Deformation(:,2),'LineWidth',3,'color',[.5 .5 .5]);
hold on
load('Shank90_Deformation.mat');
plot(Shank50_Deformation(:,1), 1000*Shank50_Deformation(:,2),'LineWidth',3,'color',[.5 .5 .5]);
hold on
legend('Calf Displacement');
% Thigh
load('Thigh45_Deformation.mat');
plot(Thigh50_Deformation(:,1), 1000*Thigh50_Deformation(:,2),'LineWidth',3,'color',[.753 .0 .0]);
hold on
load('Thigh60_Deformation.mat');
plot(Thigh50_Deformation(:,1), 1000*Thigh50_Deformation(:,2),'LineWidth',3,'color',[.753 .0 .0]);
hold on
load('Thigh75_Deformation.mat');
plot(Thigh50_Deformation(:,1), 1000*Thigh50_Deformation(:,2),'LineWidth',3,'color',[.753 .0 .0]);
hold on
load('Thigh90_Deformation.mat');
plot(Thigh50_Deformation(:,1), 1000*Thigh50_Deformation(:,2),'LineWidth',3,'color',[.753 .0 .0]);

% Plot
Legend = legend('Calf Binding','Thigh Binding');
set(Legend,'FontSize',20,'FontWeight','bold'); set(Legend,'FontName','Times New Roman','FontWeight','bold');
xlabel('Knee Angle (degree)','FontSize',20,'FontName','Times New Roman','FontWeight','bold');
ylabel('Displacement (mm)','FontSize',20,'FontName','Times New Roman','FontWeight','bold');
xt = get(gca, 'XTick');
set(gca, 'FontSize', 20,'FontName','Times New Roman','FontWeight','bold');
ylim([-30 30]);
hold off


%% Range of Motion
load('ROMShank.mat');
load('ROMthigh.mat');
rootsquaresum = ROMShank.^2 + ROMThigh.^2;
rootsquaresum = 0.1*sqrt(rootsquaresum);
figure(2)
plot(1:100, rootsquaresum,'LineWidth',3,'Color',[.753 .0 .0]);
% Plot Setting
% Legend = legend('ROM');
% set(Legend,'FontSize',20,'FontWeight','bold'); set(Legend,'FontName','Times New Roman','FontWeight','bold');
xlabel('Roller Diameter (mm)','FontSize',20,'FontName','Times New Roman','FontWeight','bold');
ylabel('Displacement Factor','FontSize',20,'FontName','Times New Roman','FontWeight','bold');
xt = get(gca, 'XTick');
set(gca, 'FontSize', 20,'FontName','Times New Roman','FontWeight','bold');